/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.scripting;

import com.aptana.editor.common.internal.scripting.WizardNewTemplateFilePage;
import com.aptana.scripting.model.TemplateElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class NewTemplateFileWizard
extends BasicNewFileResourceWizard {
    private static final String MAIN_PAGE_NAME = "mainPage";
    private TemplateElement template;
    private WizardNewTemplateFilePage mainPage;

    public NewTemplateFileWizard(TemplateElement template) {
        this.template = template;
    }

    public void addPages() {
        this.mainPage = new WizardNewTemplateFilePage(MAIN_PAGE_NAME, this.getSelection(), this.template);
        this.mainPage.setTitle(ResourceMessages.FileResource_pageTitle);
        this.mainPage.setDescription(ResourceMessages.FileResource_description);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (window != null && (page = window.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError((Shell)window.getShell(), (String)ResourceMessages.FileResource_errorMessage, (String)e.getMessage(), (PartInitException)e);
        }
        return true;
    }
}

